/* Plugin generated by AMXX-Studio */

#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <xs>
#include <cstrike>
//#include <fakemeta_util>
#define PLUGIN "Laser/TripMine Entity"
#define VERSION "2.0"
#define AUTHOR "SandStriker"

#define RemoveEntity(%1)	engfunc(EngFunc_RemoveEntity,%1)
//#define ACCESSLEVEL		ADMIN_LEVEL_H
#define TASK_PLANT		15100
#define TASK_RESET		15500

#define LASERMINE_INT_TEAM	pev_iuser1 //EV_INT_iuser1
#define LASERMINE_STEP		pev_iuser2
#define LASERMINE_OWNER		pev_iuser3 //EV_INT_iuser3
#define LASERMINE_POWERUP	pev_fuser1
#define LASERMINE_BEAMTHINK	pev_fuser2

#define LASERMINE_BEAMENDPOINT	pev_vuser1
//#define MAX_MINES		10
#define MODE_LASERMINE		0

enum tripmine_e {
	TRIPMINE_IDLE1 = 0,
	TRIPMINE_IDLE2,
	TRIPMINE_ARM1,
	TRIPMINE_ARM2,
	TRIPMINE_FIDGET,
	TRIPMINE_HOLSTER,
	TRIPMINE_DRAW,
	TRIPMINE_WORLD,
	TRIPMINE_GROUND,
};

enum
{
	POWERUP_THINK,
	BEAMBREAK_THINK,
	EXPLOSE_THINK
};

enum
{
	POWERUP_SOUND,
	ACTIVATE_SOUND,
	STOP_SOUND
};

new const
	ENT_MODELS[]	= "models/v_tripmine.mdl",
	ENT_SOUND1[]	= "weapons/mine_deploy.wav",
	ENT_SOUND2[]	= "weapons/mine_charge.wav",
	ENT_SOUND3[]	= "weapons/mine_activate.wav",
	ENT_SOUND4[]	= "debris/beamstart9.wav",
	ENT_SOUND5[]	= "items/gunpickup2.wav",
	//ENT_SOUND6[]	= "weapons/mine_activate.wav",
	ENT_SPRITE1[] 		= "sprites/laserbeam.spr",
	ENT_SPRITE2[] 		= "sprites/zerogxplode.spr";

new const
	ENT_CLASS_NAME[]	= "lasermine",
	//ENT_CLASS_NAME2[]	= "info_target",
	ENT_CLASS_NAME3[]	= "func_breakable";

new const
	CHATTAG[] 		= "[LaserMines]",
	//STR_MINEDETNATED[] 	= "Your mine has detonated.",
	//STR_MINEDETNATED2[]	= "detonated your mine.",
	STR_NOTACTIVE[] 	= "Lasermines are not currently active.",
	STR_DONTHAVEMINE[]	= "You don't have lasermine.",
	STR_CANTDEPLOY[]	= "Your team can't deploying lasermine!",
	STR_MAXDEPLOY[]		= "Maximum mines have been deployed.",
	STR_MANYPPL[]		= "Too many ppl on your team...",
	STR_PLANTWALL[]		= "You must plant the lasermine on a wall!",
	STR_REF[]		= "Refer to a lasermine rule with this server. say 'lasermine'",
	STR_CBT[]		= "Your team can't buying lasermine!",
	STR_HAVEMAX[]		= "You have a maximum lasermine.",
	STR_NOMONEY[]		= "You don't have enough money to buy a lasermine! ($",
	STR_NEEDED[]		= "needed)",
	STR_DELAY[]		= "You can buying and deploying lasermine in after",
	STR_SECONDS[]		= "seconds.",
	STR_BOUGHT[]		= "You have successfully bought a lasermine.",
	STR_STATE[]		= "LaserMines Ammo:";

new g_EntMine;
new beam, boom
new 
	g_LENABLE,g_LFMONEY,g_LAMMO,g_LDMG,
	g_LTMAX,g_LCOST,g_LHEALTH,g_LMODE,g_LRADIUS,g_LRDMG,g_LFF,g_LCBT,
	g_LDELAY,/*g_LTHINK,*/g_LVISIBLE;

new g_dcount,g_nowtime,g_MaxPL
new bool:g_settinglaser[33]
new g_msgDeathMsg,g_msgScoreInfo,g_msgDamage,g_msgStatusText;
new Float:plspeed[33]
new plsetting[33]
new g_havemine[33];
new g_deployed[33];

public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	// Add your code here...
	register_clcmd("+setlaser","CreateLaserMine_Progress");
   	register_clcmd("-setlaser","StopCreateLaserMine");
	register_clcmd("say","say_lasermine");
	register_clcmd("buy_lasermine","BuyLasermine");
	g_LENABLE = register_cvar("amx_ltm","1")

	g_LMODE = register_cvar("amx_ltm_mode","0")
	g_LAMMO = register_cvar("amx_ltm_ammo","2")
	g_LDMG = register_cvar("amx_ltm_dmg","10000")
	g_LCOST = register_cvar("amx_ltm_cost","2500")
	g_LFMONEY = register_cvar("amx_ltm_fragmoney","300")
	g_LHEALTH = register_cvar("amx_ltm_health","500")
	g_LTMAX = register_cvar("amx_ltm_teammax","10")
	g_LRADIUS = register_cvar("amx_ltm_radius","200.0")
	g_LRDMG = register_cvar("amx_ltm_rdmg","1000")
	g_LFF = register_cvar("amx_ltm_ff","0")
	g_LCBT = register_cvar("amx_ltm_cbt","ALL")
	g_LDELAY = register_cvar("amx_ltm_delay","15")
	//g_LTHINK = register_cvar("amx_ltm_think","0.01")
	g_LVISIBLE = register_cvar("amx_ltm_line","1")
	
	register_event("DeathMsg", "DeathEvent", "a")
 	register_event("CurWeapon", "standing", "be", "1=1")
	register_event("ResetHUD", "delaycount", "a")
	register_event("ResetHUD", "newround", "b")

	g_msgDeathMsg 	= get_user_msgid("DeathMsg")
	g_msgScoreInfo	= get_user_msgid("ScoreInfo")
	g_msgDamage 	= get_user_msgid("Damage")
	g_msgStatusText = get_user_msgid("StatusText")

	// -- Forward.
	register_forward( FM_Think, "ltm_Think" );
	register_forward( FM_PlayerPostThink, "ltm_PostThink" );
}

public plugin_precache() 
{
	precache_sound(ENT_SOUND1);
	precache_sound(ENT_SOUND2);
	precache_sound(ENT_SOUND3);
	precache_sound(ENT_SOUND4);
	precache_sound(ENT_SOUND5);
	precache_model(ENT_MODELS);
	beam = precache_model(ENT_SPRITE1);
	boom = precache_model(ENT_SPRITE2);
	
	return PLUGIN_CONTINUE;
}

public plugin_modules() 
{
	require_module("fakemeta")
	require_module("cstrike")
	//require_module("fun")
}

public plugin_cfg()
{
	g_EntMine = engfunc(EngFunc_AllocString,ENT_CLASS_NAME3);
	arrayset(g_havemine,0,sizeof(g_havemine));
	arrayset(g_deployed,0,sizeof(g_deployed));
	g_MaxPL = get_maxplayers();
}

public delaycount()
{
	g_dcount = floatround(get_gametime())
}

bool:CheckTime()
{
	g_nowtime = floatround(get_gametime()) - g_dcount
	if(g_nowtime >= get_pcvar_num(g_LDELAY))
		return true
	return false
}

public CreateLaserMine_Progress(id){ 


	if (!CreateCheck(id))
		return PLUGIN_HANDLED;
	g_settinglaser[id] = true

	message_begin( MSG_ONE, 108, {0,0,0}, id );
	write_byte(1);
	write_byte(0);
	message_end();


	new PID[1];
	PID[0] = id;
	set_task(1.2, "Spawn", (TASK_PLANT + id), PID, 1);

	return PLUGIN_HANDLED;
}

public StopCreateLaserMine(id)
{
	if (task_exists((TASK_PLANT + id)))
	{
		remove_task((TASK_PLANT + id));
	}
	g_settinglaser[id] = false

	message_begin(MSG_ONE, 108, {0,0,0}, id)
	write_byte(0);
	write_byte(0);
	message_end();

	return PLUGIN_HANDLED;
}

public Spawn( ids[] )
{
	new id = ids[0];
	// motor
	new i_Ent = engfunc(EngFunc_CreateNamedEntity,g_EntMine);
	if(!i_Ent) {
		client_print(id,print_chat,"[Laesrmine Debug] Can't Create Entity")
		return PLUGIN_HANDLED_MAIN;
	}
	set_pev(i_Ent,pev_classname,ENT_CLASS_NAME)

	engfunc(EngFunc_SetModel,i_Ent,ENT_MODELS);

	set_pev(i_Ent,pev_solid,SOLID_NOT);
	set_pev(i_Ent,pev_movetype,MOVETYPE_FLY);

	set_pev(i_Ent,pev_frame,0);
	set_pev(i_Ent,pev_body,3);
	set_pev(i_Ent,pev_sequence,TRIPMINE_WORLD);
	set_pev(i_Ent,pev_framerate,0);
    
	set_pev(i_Ent,pev_takedamage,DAMAGE_YES);
	set_pev(i_Ent,pev_dmg,100.0);
	set_pev(i_Ent,pev_health, float(get_pcvar_num(g_LHEALTH)));
	new Float:vOrigin[3];
	new	Float:vNewOrigin[3],Float:vNormal[3],Float:vTraceDirection[3],
		Float:vTraceEnd[3],Float:vEntAngles[3];
	pev( id, pev_origin, vOrigin );
	velocity_by_aim( id, 128, vTraceDirection );
	xs_vec_add( vTraceDirection, vOrigin, vTraceEnd );
	
	engfunc( EngFunc_TraceLine, vOrigin, vTraceEnd, DONT_IGNORE_MONSTERS, id, 0 );
	
	new Float:fFraction;
	get_tr2( 0, TR_flFraction, fFraction );
	

	// -- We hit something!
	if ( fFraction < 1.0 )
	{
		// -- Save results to be used later.
		get_tr2( 0, TR_vecEndPos, vTraceEnd );
		get_tr2( 0, TR_vecPlaneNormal, vNormal );
	}


	xs_vec_mul_scalar( vNormal, 8.0, vNormal );
	xs_vec_add( vTraceEnd, vNormal, vNewOrigin );

	engfunc(EngFunc_SetSize, i_Ent, Float:{ -8.0, -8.0, -8.0 }, Float:{ 8.0, 8.0, 8.0 } );
	engfunc(EngFunc_SetOrigin, i_Ent, vNewOrigin );

	// -- Rotate tripmine.
	vector_to_angle(vNormal,vEntAngles );
	set_pev(i_Ent,pev_angles,vEntAngles );

	// -- Calculate laser end origin.
	new Float:vBeamEnd[3], Float:vTracedBeamEnd[3];
        
	xs_vec_mul_scalar(vNormal, 8192.0, vNormal );
	xs_vec_add( vNewOrigin, vNormal, vBeamEnd );

	engfunc( EngFunc_TraceLine, vNewOrigin, vBeamEnd, IGNORE_MONSTERS, -1, 0 );

	get_tr2( 0, TR_vecPlaneNormal, vNormal );
	get_tr2( 0, TR_vecEndPos, vTracedBeamEnd );

	// -- Save results to be used later.
	set_pev(i_Ent, LASERMINE_OWNER, id );
	set_pev(i_Ent,LASERMINE_BEAMENDPOINT,vTracedBeamEnd);
	set_pev(i_Ent,LASERMINE_INT_TEAM,int:cs_get_user_team(id));

	new Float:fCurrTime = get_gametime();

	set_pev(i_Ent,LASERMINE_POWERUP, fCurrTime + 2.5 );
   
	set_pev(i_Ent,LASERMINE_STEP,POWERUP_THINK);
	set_pev(i_Ent,pev_nextthink, fCurrTime + 0.2 );

	PlaySound(i_Ent,POWERUP_SOUND );
	g_deployed[id]++;
	g_havemine[id]--;
	g_settinglaser[id] = false
	ShowAmmo(id);
	return 1;
}

stock TeamDeployedCount(id)
{
	//new tid[32];
	
	static i;
	static CsTeams:t;t = cs_get_user_team(id);
	static cnt;cnt=0;

	for(i = 1;i <= g_MaxPL;i++)
	{
		if(is_user_connected(i))
			if(t == cs_get_user_team(i))
				cnt += g_deployed[i];
	}

	return cnt;
}



bool:CheckCanTeam(id)
{
	new arg[5],CsTeam:num
	get_pcvar_string(g_LCBT,arg,3)
	if(equali(arg,"T")){
		num = CsTeam:CS_TEAM_T
	}
	else if(equali(arg,"CT")){
		num = CsTeam:CS_TEAM_CT
	}
	else if(equali(arg,"ALL")){
		num = CsTeam:CS_TEAM_UNASSIGNED
	}	
	else{
		num = CsTeam:CS_TEAM_UNASSIGNED
	}
	if(num != CsTeam:CS_TEAM_UNASSIGNED && num != CsTeam:cs_get_user_team(id))
		return false;
	return true
}

bool:CreateCheck( id )
{
	if( !get_pcvar_num( g_LENABLE ) )
	{
		client_print(id, print_chat, "%s %s",CHATTAG,STR_NOTACTIVE)
		return false
	}
	if(g_settinglaser[id] || task_exists((TASK_PLANT + id))) return false
	if(!is_user_alive(id)) return false
	if(!CheckTime()){
		client_print(id,print_chat, "%s %s %d %s",CHATTAG,STR_DELAY,get_pcvar_num(g_LDELAY)-g_nowtime,STR_SECONDS)
		return false
	}
	if(g_havemine[id] <= 0){
		client_print(id, print_chat, "%s %s",CHATTAG,STR_DONTHAVEMINE)
		return false
	}
	
	if (!CheckCanTeam(id))
	{
		client_print(id, print_chat, "%s %s",CHATTAG,STR_CANTDEPLOY)	
		return false
	}
	if (g_deployed[id] >= get_pcvar_num(g_LAMMO))  //unhandled error
	{
		client_print(id, print_chat, "%s %s",CHATTAG,STR_MAXDEPLOY)
		return false
	}
	//client_print(id,print_chat,"[Lasermine] your team deployed %d",TeamDeployedCount(id))
	if(TeamDeployedCount(id) >= get_pcvar_num(g_LTMAX))
	{
		client_print(id, print_chat, "%s %s",CHATTAG,STR_MANYPPL)
		return false
	}
	new Float:vTraceDirection[3], Float:vTraceEnd[3],Float:vOrigin[3];
	
	pev( id, pev_origin, vOrigin );
	velocity_by_aim( id, 128, vTraceDirection );
	xs_vec_add( vTraceDirection, vOrigin, vTraceEnd );
	
	engfunc( EngFunc_TraceLine, vOrigin, vTraceEnd, DONT_IGNORE_MONSTERS, id, 0 );
	
	new Float:fFraction,Float:vTraceNormal[3];
	get_tr2( 0, TR_flFraction, fFraction );
	
	// -- We hit something!
	if ( fFraction < 1.0 )
	{
		// -- Save results to be used later.
		get_tr2( 0, TR_vecEndPos, vTraceEnd );
		get_tr2( 0, TR_vecPlaneNormal, vTraceNormal );

		//get_tr2( 0, TR_pHit );

		return true;
	}
	client_print(id, print_chat, "%s %s",CHATTAG,STR_PLANTWALL)
	g_settinglaser[id] = false
	// -- Did not touched something. (not solid)
	return false;
}

public ltm_Think( i_Ent )
{
	if ( !pev_valid( i_Ent ) )
		return FMRES_IGNORED;
	new EntityName[sizeof(ENT_CLASS_NAME)+1];
	static const size = sizeof(ENT_CLASS_NAME);
	pev( i_Ent, pev_classname, EntityName, size);
	if(!get_pcvar_num(g_LENABLE)) return FMRES_IGNORED;
	// -- Entity is not a tripmine, ignoring the next...
	if ( !equal( EntityName, ENT_CLASS_NAME ) )
		return FMRES_IGNORED;

	static Float:fCurrTime;
	fCurrTime = get_gametime();

	switch( pev( i_Ent, LASERMINE_STEP ) )
	{
		case POWERUP_THINK :
		{
			new Float:fPowerupTime;
			pev( i_Ent, LASERMINE_POWERUP, fPowerupTime );

			if( fCurrTime > fPowerupTime )
			{
				set_pev( i_Ent, pev_solid, SOLID_BBOX );
				set_pev( i_Ent, LASERMINE_STEP, BEAMBREAK_THINK );

				PlaySound( i_Ent, ACTIVATE_SOUND );
			}

			set_pev( i_Ent, pev_nextthink, fCurrTime + 0.1 );
		}
		case BEAMBREAK_THINK :
		{
			static Float:vEnd[3],Float:vOrigin[3];
			pev( i_Ent, pev_origin, vOrigin );
			pev( i_Ent, LASERMINE_BEAMENDPOINT, vEnd );

			static iHit, Float:fFraction;
			engfunc( EngFunc_TraceLine, vOrigin, vEnd, DONT_IGNORE_MONSTERS, i_Ent, 0 );

			get_tr2( 0, TR_flFraction, fFraction );
			iHit = get_tr2( 0, TR_pHit );

			// -- Something has passed the laser.
			if ( fFraction < 1.0 )
			{
				// -- Ignoring others tripmines entity.
				pev( iHit, pev_classname, EntityName, size );

				if( !equal( EntityName, ENT_CLASS_NAME ) )
				{
					set_pev( i_Ent, pev_enemy, iHit );
					if(get_pcvar_num(g_LMODE) == MODE_LASERMINE)
						CreateLaserDamage(i_Ent,iHit);
					else
						set_pev( i_Ent, LASERMINE_STEP, EXPLOSE_THINK );
                        
					set_pev( i_Ent, pev_nextthink, fCurrTime + random_float( 0.1, 0.3 ) );
				}
			}
                
			// -- Tripmine is still there.
			if ( pev_valid( i_Ent ) )
			{
				static Float:fHealth;
				pev( i_Ent, pev_health, fHealth );

				if( fHealth < 0 )
				{
					set_pev( i_Ent, LASERMINE_STEP, EXPLOSE_THINK );
					set_pev( i_Ent, pev_nextthink, fCurrTime + random_float( 0.1, 0.3 ) );
				}
                    
				static Float:fBeamthink;
				pev( i_Ent, LASERMINE_BEAMTHINK, fBeamthink );
                    
				if( fBeamthink < fCurrTime && get_pcvar_num(g_LVISIBLE) && pev(i_Ent, LASERMINE_STEP) != EXPLOSE_THINK)
				{
					DrawLaser(i_Ent, vOrigin, vEnd );
					set_pev( i_Ent, LASERMINE_BEAMTHINK, fCurrTime + 0.1 );
				}

				set_pev( i_Ent, pev_nextthink, fCurrTime + 0.01 );
			}
		}
		case EXPLOSE_THINK :
		{
			// -- Stopping entity to think
			set_pev( i_Ent, pev_nextthink, 0.0 );
			PlaySound( i_Ent, STOP_SOUND );
			g_deployed[pev(i_Ent,LASERMINE_OWNER)]--;
			CreateExplosion( i_Ent );
			CreateDamage(i_Ent,get_pcvar_num(g_LRDMG),get_pcvar_float(g_LRADIUS))
			RemoveEntity   ( i_Ent );
		}
	}

	return FMRES_IGNORED;
}

PlaySound( i_Ent, i_SoundType )
{
	switch ( i_SoundType )
	{
		case POWERUP_SOUND :
		{
			emit_sound( i_Ent, CHAN_VOICE, ENT_SOUND1, VOL_NORM, ATTN_NORM, 0, PITCH_NORM );
			emit_sound( i_Ent, CHAN_BODY , ENT_SOUND2, 0.2, ATTN_NORM, 0, PITCH_NORM );
		}
		case ACTIVATE_SOUND :
		{
			emit_sound( i_Ent, CHAN_VOICE, ENT_SOUND3, 0.5, ATTN_NORM, 1, 75 );
		}
		case STOP_SOUND :
		{
			emit_sound( i_Ent, CHAN_BODY , ENT_SOUND2, 0.2, ATTN_NORM, SND_STOP, PITCH_NORM );
			emit_sound( i_Ent, CHAN_VOICE, ENT_SOUND3, 0.5, ATTN_NORM, SND_STOP, 75 );
		}
	}
}

DrawLaser(i_Ent, const Float:v_Origin[3], const Float:v_EndOrigin[3] )
{
	new tcolor[3];
	new teamid = pev(i_Ent, LASERMINE_INT_TEAM);
	switch(teamid){
		case 1:{
			tcolor[0] = 255
			tcolor[1] = 0
			tcolor[2] = 0
		}
		case 2:{
			tcolor[0] = 0
			tcolor[1] = 0
			tcolor[2] = 255
		}
	}
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY) 
	write_byte(TE_BEAMPOINTS)
	engfunc(EngFunc_WriteCoord,v_Origin[0])
	engfunc(EngFunc_WriteCoord,v_Origin[1])
	engfunc(EngFunc_WriteCoord,v_Origin[2])
	engfunc(EngFunc_WriteCoord,v_EndOrigin[0]) //Random
	engfunc(EngFunc_WriteCoord,v_EndOrigin[1]) //Random
	engfunc(EngFunc_WriteCoord,v_EndOrigin[2]) //Random
	write_short(beam)
	write_byte(0)
	write_byte(0)
	write_byte(11) //Life
	write_byte(5) //Width
	write_byte(0)//wave
	write_byte(tcolor[0]) // r
	write_byte(tcolor[1]) // g
	write_byte(tcolor[2]) // b
	write_byte(255)
	write_byte(255)
	message_end() 
}

CreateDamage(iCurrent,DmgMAX,Float:Radius)
{
	new AtkID = pev(iCurrent,LASERMINE_OWNER)// entity_get_int(iCurrent,LASERMINE_OWNER)
	new TeamID= pev(iCurrent,LASERMINE_INT_TEAM) //entity_get_int(iCurrent,LASERMINE_INT_TEAM)
	new Player = -1;
	new Float:distance,dmg;
	new Float:tOrigin[3];
	new Float:vOrigin[3];
	new iHitHP,iHitTeam;
	pev(iCurrent,pev_origin,vOrigin);
	Player = engfunc(EngFunc_FindEntityInSphere,Player,vOrigin,Radius);
	while(Player != 0)
	{
		if(is_user_alive(Player))
		{
			pev(Player,pev_origin,tOrigin)
			distance = get_distance_f(vOrigin, tOrigin)
			dmg = floatround(DmgMAX - ((DmgMAX / Radius) * distance))
			iHitHP = pev_user_health(Player) - dmg
			iHitTeam = int:cs_get_user_team(Player)
			if(iHitHP <= 0)
			{
				if(iHitTeam != TeamID)
				{
					cs_set_user_money(AtkID,cs_get_user_money(AtkID) + get_pcvar_num(g_LFMONEY))
					set_score(AtkID,Player,1,iHitHP)
				}else
				{
					if(get_pcvar_num(g_LFF))
					{
						cs_set_user_money(AtkID,cs_get_user_money(AtkID) - get_pcvar_num(g_LFMONEY))
						set_score(AtkID,Player,-1,iHitHP)
					}
				}
			}else
			{
				if(iHitTeam != TeamID || get_pcvar_num(g_LFF))
				{
					//set_pev(Player,pev_health,iHitHP)
					set_user_health(Player, iHitHP)
					message_begin(MSG_ONE_UNRELIABLE, g_msgDamage, {0,0,0}, Player) 
					write_byte(dmg)
					write_byte(dmg)
					write_long(DMG_BULLET)
					engfunc(EngFunc_WriteCoord,vOrigin[0])
					engfunc(EngFunc_WriteCoord,vOrigin[1])
					engfunc(EngFunc_WriteCoord,vOrigin[2])
					message_end()
				}
			}
		}
		Player =  engfunc(EngFunc_FindEntityInSphere,Player,vOrigin,Radius)
	}
	return PLUGIN_CONTINUE
}

CreateExplosion(iCurrent)
{
	
	new Float:vOrigin[3]
	pev(iCurrent,pev_origin,vOrigin)
	//entity_get_vector(iCurrent, EV_VEC_origin, vOrigin)

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(99) //99 = KillBeam
	write_short(iCurrent)
	message_end()

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(3)
	engfunc(EngFunc_WriteCoord,vOrigin[0])
	engfunc(EngFunc_WriteCoord,vOrigin[1])
	engfunc(EngFunc_WriteCoord,vOrigin[2])
	write_short(boom)
	write_byte(50)
	write_byte(15)
	write_byte(0)
	message_end()
	/*
	if (iHit == -1)
	{
		client_print(id, print_chat, "%s %s",CHATTAG,STR_MINEDETNATED)
	} else 
	{
		szNetName[0] = '^0'
		engfunc(EngFunc_AllocString,iHit,szNetName)
		//entity_get_string(iHit, EV_SZ_netname, szNetName, 32)
		client_print(id, print_chat, "%s %s %s",CHATTAG,szNetName,STR_MINEDETNATED2)
	}
	*/
}

CreateLaserDamage(iCurrent,isHit)
{
	new Float:vOrigin[3],Float:vEnd[3]
	pev(iCurrent,pev_origin,vOrigin)
	pev(iCurrent,pev_vuser1,vEnd)

	//new isHit = fm_trace_line(iCurrent, vOrigin, vEnd, vTrace)
	new teamid = pev(iCurrent, LASERMINE_INT_TEAM)

	new szClassName[32]
	new Alive,God
	new iHitTeam,iHitHP,id
	new hitscore

	if(isHit < 0 ) return PLUGIN_CONTINUE
	
	szClassName[0] = '^0'
	pev(isHit,pev_classname,szClassName,32)
	
	if(equal(szClassName, "player"))
	{
		Alive = is_user_alive(isHit)
		God = get_user_godmode(isHit)
		if(!Alive || God) return PLUGIN_CONTINUE
			 
		iHitTeam = int:cs_get_user_team(isHit)
		//iHitHP = entity_get_float(isHit,EV_FL_health) - float(LASER_HIT_DMG)
		iHitHP = pev_user_health(isHit) - get_pcvar_num(g_LDMG)
		id = pev(iCurrent,LASERMINE_OWNER)//, szNetName[32]
		if( get_pcvar_num(g_LMODE) == MODE_LASERMINE)
		{
			if(iHitHP <= 0)
			{
				if(iHitTeam != teamid)
				{
					hitscore = 1
					cs_set_user_money(id,cs_get_user_money(id) + get_pcvar_num(g_LFMONEY))
					//set_user_health(iHit, 0)	
					//entity_set_float(iHit, EV_FL_health,0.0)
					emit_sound(isHit, CHAN_WEAPON, ENT_SOUND4, 1.0, ATTN_NORM, 0, PITCH_NORM )
					set_score(id,isHit,hitscore,iHitHP)
					//entity_get_string(iHit, EV_SZ_netname, szNetName, 32)
					//client_print(id, print_chat, "[LaserMines] %s killed your mine.",szNetName)
				}else
				{
					if(get_pcvar_num(g_LFF))
					{
						hitscore = -1									
						cs_set_user_money(id,cs_get_user_money(id) - get_pcvar_num(g_LFMONEY))
						emit_sound(isHit, CHAN_WEAPON, ENT_SOUND4, 1.0, ATTN_NORM, 0, PITCH_NORM )
						set_score(id,isHit,hitscore,iHitHP)
						//set_user_health(iHit, 0)
						//entity_set_float(iHit, EV_FL_health, 0.0)
						//entity_get_string(iHit, EV_SZ_netname, szNetName, 32)
						//client_print(id, print_chat, "[LaserMines] %s killed your mine.",szNetName)
					}
				}
			}else if(iHitTeam != teamid || get_pcvar_num(g_LFF))
			{
				//entity_set_float(isHit,EV_FL_health,iHitHP)
				//set_user_health(isHit, iHitHP)
				set_user_health(isHit,iHitHP)
				message_begin(MSG_ONE_UNRELIABLE, g_msgDamage, {0,0,0}, isHit) 
				write_byte(get_pcvar_num(g_LDMG))
				write_byte(get_pcvar_num(g_LDMG))
				write_long(DMG_BULLET)
				engfunc(EngFunc_WriteCoord,vOrigin[0])
				engfunc(EngFunc_WriteCoord,vOrigin[1])
				engfunc(EngFunc_WriteCoord,vOrigin[2])
				message_end()
			}
		}else
		{
			CreateExplosion(iCurrent)
			CreateDamage(iCurrent,get_pcvar_num(g_LRDMG),get_pcvar_float(g_LRADIUS))
			RemoveEntity(iCurrent);
		}
	}else if(equal(szClassName, ENT_CLASS_NAME3))
	{
		new hl;
		hl = pev_user_health(isHit);
		set_user_health(isHit,hl-get_pcvar_num(g_LDMG));
	}
	return PLUGIN_CONTINUE
}

stock pev_user_health(id)
{
	new Float:health
	pev(id,pev_health,health)
	return floatround(health)
}

stock set_user_health(id,health)
{
	health > 0 ? set_pev(id, pev_health, float(health)) : dllfunc(DLLFunc_ClientKill, id);
}

stock get_user_godmode(index)
{
	new Float:val
	pev(index, pev_takedamage, val)

	return (val == DAMAGE_NO)
}

stock set_user_frags(index, frags)
{
	set_pev(index, pev_frags, float(frags))

	return 1
}

stock pev_user_frags(index)
{
	new Float:frags;
	pev(index,pev_frags,frags);
	return floatround(frags);
}

set_score(id,target,hitscore,HP){

	new idfrags = pev_user_frags(id) + hitscore// get_user_frags(id) + hitscore	
	set_user_frags(id,idfrags)
	//set_user_frags(id, idfrags)
	//entity_set_float(id, EV_FL_frags, float(idfrags))
	
	new tarfrags = pev_user_frags(target) + 1 //get_user_frags(target) + 1
	set_user_frags(target,tarfrags)
	//set_user_frags(target,tarfrags)
	//entity_set_float(target, EV_FL_frags, float(tarfrags))
	
	new idteam = int:cs_get_user_team(id)
	new iddeaths = cs_get_user_deaths(id)


	message_begin(MSG_ALL, g_msgDeathMsg, {0, 0, 0} ,0)
	write_byte(id)
	write_byte(target)
	write_byte(0)
	write_string(ENT_CLASS_NAME)
	message_end()

	message_begin(MSG_ALL, g_msgScoreInfo)
	write_byte(id)
	write_short(idfrags)
	write_short(iddeaths)
	write_short(0)
	write_short(idteam)
	message_end()

	set_msg_block(g_msgDeathMsg, BLOCK_ONCE)

	//entity_set_float(target, EV_FL_health,float(HP))
	set_user_health(target, HP)
	//set_pev(target,pev_health,HP)

}

public BuyLasermine(id)
{	
	if( !get_pcvar_num( g_LENABLE )  ){
		client_print(id, print_chat, "%s %s",CHATTAG,STR_NOTACTIVE)
		return PLUGIN_CONTINUE
	}
	if (!CheckCanTeam(id))
	{
		client_print(id, print_chat, "%s %s",CHATTAG,STR_CBT)	
		return PLUGIN_HANDLED
	}
	if (cs_get_user_money(id) < get_pcvar_num(g_LCOST)) {
		client_print(id, print_chat, "%s %s%d %s",CHATTAG, STR_NOMONEY,get_pcvar_num(g_LCOST),STR_NEEDED)	
		return PLUGIN_HANDLED
	}
	if (g_havemine[id] >= get_pcvar_num(g_LAMMO)){
		client_print(id, print_chat, "%s %s",CHATTAG,STR_HAVEMAX)	
		return PLUGIN_HANDLED
	}
	if(!CheckTime())
	{
		client_print(id,print_chat, "%s %s %d %s",CHATTAG,STR_DELAY,get_pcvar_num(g_LDELAY)-g_nowtime,STR_SECONDS)
		return PLUGIN_HANDLED
	}
	cs_set_user_money(id,cs_get_user_money(id) - get_pcvar_num(g_LCOST))
	g_havemine[id]++;
	emit_sound(id, CHAN_ITEM, ENT_SOUND5, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
	client_print(id, print_chat, "%s %s",CHATTAG,STR_BOUGHT)
	ShowAmmo(id)
	return PLUGIN_HANDLED
}

ShowAmmo(id)
{ 
    new ammo[51] 
    formatex(ammo, 50, "%s %i/%i",STR_STATE, g_havemine[id],get_pcvar_num(g_LAMMO))

    message_begin(MSG_ONE, g_msgStatusText, {0,0,0}, id) 
    write_byte(0) 
    write_string(ammo) 
    message_end() 
} 

public showInfo(id)
{
	client_print(id, print_chat, STR_REF)
}

public say_lasermine(id){
	new said[32]
	read_argv(1,said,31);
	if( !get_pcvar_num( g_LENABLE )  ){
//		client_print(id, print_chat, "%s Lasermines are not currently active.",CHATTAG)
		return PLUGIN_CONTINUE
	}
	
	if (equali(said,"/buy lasermine")||equali(said,"/lm")){
		BuyLasermine(id)
	}else if (equali(said, "lasermine") || equali(said, "/lasermine")){
		const SIZE = 1024
		new msg[SIZE+1],len = 0;
		len += formatex(msg[len], SIZE - len, "<html><body>")
		len += formatex(msg[len], SIZE - len, "<p><b>LaserMine</b></p><br/><br/>")
		len += formatex(msg[len], SIZE - len, "<p>You can be setting the mine on the wall.</p><br/>")
		len += formatex(msg[len], SIZE - len, "<p>That laser will give what touched it damage.</p><br/><br/>")
		len += formatex(msg[len], SIZE - len, "<p><b>LaserMine Commands</b></p><br/><br/>")
		len += formatex(msg[len], SIZE - len, "<p><b>Say /buy lasermine</b> or <b>Say /lm</b> //buying lasermine<br/>")
		len += formatex(msg[len], SIZE - len, "<b>buy_lasermine</b> //bind ^"F2^" buy_lasermine : using F2 buying lasermine<br/>")
		len += formatex(msg[len], SIZE - len, "<b>+setlaser</b> //bind mouse3 +setlaser : using mouse3 set lasermine on wall<br/>")
		len += formatex(msg[len], SIZE - len, "</body></html>")
		show_motd(id, msg, "Lasermine Entity help")
		return PLUGIN_CONTINUE
	}
	else if (containi(said, "laser") != -1) {
		showInfo(id)
		return PLUGIN_CONTINUE
	}
	return PLUGIN_CONTINUE
}

public standing(id) {
	if (!g_settinglaser[id])
		return PLUGIN_CONTINUE

	set_pev(id, pev_maxspeed, 1.0)
//	ShowAmmo(id)

	return PLUGIN_CONTINUE
}

public ltm_PostThink(id) {
	if (!g_settinglaser[id] && plsetting[id]){
		resetspeed(id)
	}
	else if (g_settinglaser[id] && !plsetting[id]) {
		pev(id, pev_maxspeed,plspeed[id])
		set_pev(id, pev_maxspeed, 1.0)
	}
	plsetting[id] = g_settinglaser[id]
	return FMRES_IGNORED
}

resetspeed(who) {
	set_pev(who, pev_maxspeed, plspeed[who])
}

public client_putinserver(id){
	g_deployed[id] = 0;
	g_havemine[id] = 0;
	g_settinglaser[id] = false;
	return PLUGIN_CONTINUE
}

public client_disconnect(id){
	if(!get_pcvar_num( g_LENABLE ))
		return PLUGIN_CONTINUE
	g_settinglaser[id] = false
	RemoveAllTripmines(id);
	return PLUGIN_CONTINUE
}


public newround(id){
	if(!get_pcvar_num( g_LENABLE ))
		return PLUGIN_CONTINUE
	pev(id, pev_maxspeed,plspeed[id])
	g_settinglaser[id] = false
	RemoveAllTripmines(id);
	return PLUGIN_CONTINUE
}

public DeathEvent(){
	if(!get_pcvar_num( g_LENABLE ))
		return PLUGIN_CONTINUE

	new id = read_data(2)
	if (task_exists(TASK_PLANT+id))
		remove_task(TASK_PLANT+id)
	g_settinglaser[id] = false
	return PLUGIN_CONTINUE
}

RemoveAllTripmines( i_Owner )
{
	new iEnt = g_MaxPL + 1;
	new clsname[32];
	while( ( iEnt = engfunc( EngFunc_FindEntityByString, iEnt, "classname", ENT_CLASS_NAME ) ) )
	{
		if ( i_Owner )
		{
			if( pev( iEnt, LASERMINE_OWNER ) != i_Owner )
				continue;
			clsname[0] = '^0'
			pev( iEnt, pev_classname, clsname, sizeof(clsname)-1 );
                
			if ( equali( clsname, ENT_CLASS_NAME ) )
			{
				PlaySound( iEnt, STOP_SOUND );
				RemoveEntity( iEnt );
			}
		}
		else
			set_pev( iEnt, pev_flags, FL_KILLME );
	}
	g_deployed[i_Owner]=0;
}
